#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 3 and OutputCompare 4 */
#if defined (__dsPIC30F3011__) || defined (__dsPIC30F4011__) || defined (__dsPIC30F6010__) || \
    defined (__dsPIC30F5011__) || defined (__dsPIC30F6011__) || defined (__dsPIC30F6012__) || \
    defined (__dsPIC30F5013__) || defined (__dsPIC30F6013__) || defined (__dsPIC30F6014__) || \
    defined (__dsPIC30F4013__) || defined (__dsPIC30F5015__)

/********************************************************************
*    Function Name:  ReadDCOC3PWM                                   *
*    Description:    This routine reads duty cycle from Secondary   *
*                    register in PWM mode                           *
*    Parameters:     None                                           *
*    Return Value:  unsigned int: duty cycle from Secondary register*
********************************************************************/

unsigned int ReadDCOC3PWM()
{
    /* check if OC is in PWM Mode */
    if((OC3CONbits.OCM & 0x06) == 0x06)
    {       
        return OC3RS;/* Output Compare Secondary Register */
    }
    else 
        return -1;
}

#endif
